#ifndef _LIB_ACTIVEOBJECTMANAGER_H_
#define _LIB_ACTIVEOBJECTMANAGER_H_

#include "c4d_library.h"
#include "c4d_string.h"


class AtomArray;


// predefined Modes
enum ACTIVEOBJECTMODE
{
	ACTIVEOBJECTMODE_NONE,

	ACTIVEOBJECTMODE_OBJECT,
	ACTIVEOBJECTMODE_TAG,
	ACTIVEOBJECTMODE_MATERIAL,
	ACTIVEOBJECTMODE_SHADER,
	ACTIVEOBJECTMODE_NODE,
	ACTIVEOBJECTMODE_TIMELINE,
	ACTIVEOBJECTMODE_FCURVE,
	ACTIVEOBJECTMODE_BITMAPINFO, // for BODYPAINT 2

	ACTIVEOBJECTMODE_
};

typedef GeData MESSAGEHOOK(const BaseContainer &msg,void *data);

struct ActiveModeInfo
{
	ACTIVEOBJECTMODE	id;
	String						name;
	MESSAGEHOOK				*hook;
};

// ids for message hook
#define AOM_MSG_ISENABLED				'aoen'
#define AOM_MSG_GETATOMLIST			'geta'

Bool ActiveObjectManager_RegisterMode(ACTIVEOBJECTMODE id,const String &text,MESSAGEHOOK *hook);
void ActiveObjectManager_SetMode(ACTIVEOBJECTMODE id,Bool openmanager);
void ActiveObjectManager_SetObjects(ACTIVEOBJECTMODE id,AtomArray &objects,Bool openmanager);
void ActiveObjectManager_SetObject(ACTIVEOBJECTMODE id,Atom *op,Bool openmanager);
void ActiveObjectManager_Open();

Bool EditObjectModal(const AtomArray &objects,const String &dlgtitle);
Bool EditObjectModal(Atom *op,const String &dlgtitle);
Bool EditDescription(DynamicDescription *dd,BaseContainer &bc);

Bool ActiveObjectManager_GetObjects(ACTIVEOBJECTMODE id,AtomArray &objects);
Bool ActiveObjectManager_GetModeInfo(ACTIVEOBJECTMODE id,ActiveModeInfo &info);
LONG ActiveObjectManager_GetModeCount();
Bool ActiveObjectManager_GetModeInfoIdx(LONG idx,ActiveModeInfo &info);
ACTIVEOBJECTMODE ActiveObjectManager_GetLastMode();



// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#define LIBRARY_ACTIVEOBJECTMANAGER	1000473

struct ActiveObjectManagerLib : public C4DLibrary
{
	Bool							(*RegisterMode			)(ACTIVEOBJECTMODE id,const String &text,MESSAGEHOOK *hook);
	void							(*SetMode						)(ACTIVEOBJECTMODE id,Bool openmanager);
	void							(*SetObjects				)(ACTIVEOBJECTMODE id,AtomArray &objects,Bool openmanager);
	void							(*Open							)();
	Bool							(*EditObjectModal		)(const AtomArray &objects,const String &dlgtitle);
	Bool							(*EditDescription		)(DynamicDescription *dd,BaseContainer &bc);
																				
	Bool							(*GetObjects				)(ACTIVEOBJECTMODE id,AtomArray &objects);
	Bool							(*GetModeInfo				)(ACTIVEOBJECTMODE id,ActiveModeInfo &info);
	LONG							(*GetModeCount			)();
	Bool							(*GetModeInfoIdx		)(LONG idx,ActiveModeInfo &info);
	ACTIVEOBJECTMODE	(*GetLastMode				)();
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
